/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.lang.Nullable;

public interface Specification<T>
extends Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Specification<T> not(Specification<T> spec) {
        return Specifications.negated(spec);
    }

    public static <T> Specification<T> where(Specification<T> spec) {
        return Specifications.where(spec);
    }

    default public Specification<T> and(Specification<T> other) {
        return Specifications.composed(this, other, Specifications.CompositionType.AND);
    }

    default public Specification<T> or(Specification<T> other) {
        return Specifications.composed(this, other, Specifications.CompositionType.OR);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaQuery<?> var2, CriteriaBuilder var3);
}

