/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkResult
extends JestResult {
    public BulkResult(JestResult source) {
        super(source);
    }

    public BulkResult(Gson gson) {
        super(gson);
    }

    public List<BulkResultItem> getItems() {
        LinkedList<BulkResultItem> items = new LinkedList<BulkResultItem>();
        if (this.jsonObject != null && this.jsonObject.has("items")) {
            for (JsonElement jsonElement : this.jsonObject.getAsJsonArray("items")) {
                for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
                    items.add(new BulkResultItem((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
                }
            }
        }
        return items;
    }

    public List<BulkResultItem> getFailedItems() {
        LinkedList<BulkResultItem> items = new LinkedList<BulkResultItem>();
        if (this.jsonObject != null && this.jsonObject.has("items")) {
            for (JsonElement jsonElement : this.jsonObject.getAsJsonArray("items")) {
                for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
                    JsonObject values = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if (!values.has("error")) continue;
                    items.add(new BulkResultItem((String)entry.getKey(), values));
                }
            }
        }
        return items;
    }

    public class BulkResultItem {
        public final String operation;
        public final String index;
        public final String type;
        public final String id;
        public final int status;
        public final String error;
        public final String errorType;
        public final String errorReason;
        public final Integer version;

        public BulkResultItem(String operation, String index, String type, String id, int status, String error, Integer version, String errorType, String errorReason) {
            this.operation = operation;
            this.index = index;
            this.type = type;
            this.id = id;
            this.status = status;
            this.error = error;
            this.errorType = errorType;
            this.errorReason = errorReason;
            this.version = version;
        }

        public BulkResultItem(String operation, JsonObject values) {
            this.operation = operation;
            this.index = values.get("_index").getAsString();
            this.type = values.get("_type").getAsString();
            this.id = values.has("_id") && !values.get("_id").isJsonNull() ? values.get("_id").getAsString() : null;
            this.status = values.get("status").getAsInt();
            String string = this.error = values.has("error") ? values.get("error").toString() : null;
            if (values.has("error") && values.get("error").isJsonObject()) {
                JsonObject errorObject = values.get("error").getAsJsonObject();
                this.errorType = errorObject.has("type") ? errorObject.get("type").getAsString() : null;
                this.errorReason = errorObject.has("reason") ? errorObject.get("reason").getAsString() : null;
            } else {
                this.errorType = null;
                this.errorReason = null;
            }
            this.version = values.has("_version") ? Integer.valueOf(values.get("_version").getAsInt()) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulkResultItem that = (BulkResultItem)o;
            return Objects.equals(this.status, that.status) && Objects.equals(this.operation, that.operation) && Objects.equals(this.index, that.index) && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.error, that.error) && Objects.equals(this.errorType, that.errorType) && Objects.equals(this.errorReason, that.errorReason) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.operation, this.index, this.type, this.id, this.status, this.error, this.errorType, this.errorReason, this.version);
        }
    }
}

