/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;

class ServiceConnectorCreatorRegistry {
    private static Logger logger = Logger.getLogger(Cloud.class.getName());
    private List<ServiceConnectorCreator<?, ? extends ServiceInfo>> serviceConnectorCreators = new ArrayList();

    ServiceConnectorCreatorRegistry() {
    }

    public void registerCreator(ServiceConnectorCreator<?, ? extends ServiceInfo> serviceConnectorCreator) {
        this.serviceConnectorCreators.add(serviceConnectorCreator);
    }

    public <SC, SI extends ServiceInfo> ServiceConnectorCreator<SC, SI> getServiceCreator(Class<SC> serviceConnectorType, SI serviceInfo) {
        ServiceConnectorCreator<SC, SI> serviceConnectorCreator = this.getServiceCreatorOrNull(serviceConnectorType, serviceInfo);
        if (serviceConnectorCreator != null) {
            return serviceConnectorCreator;
        }
        throw new CloudException("No suitable ServiceConnectorCreator found: service id=" + serviceInfo.getId() + ", service info type=" + serviceInfo.getClass().getName() + ", connector type=" + serviceConnectorType);
    }

    public <SC, SI extends ServiceInfo> boolean canCreate(Class<SC> serviceConnectorType, SI serviceInfo) {
        return this.getServiceCreatorOrNull(serviceConnectorType, serviceInfo) != null;
    }

    public boolean accept(ServiceConnectorCreator<?, ? extends ServiceInfo> creator, Class<?> serviceConnectorType, ServiceInfo serviceInfo) {
        boolean typeBasedAccept = serviceConnectorType == null || serviceConnectorType.isAssignableFrom(creator.getServiceConnectorType());
        boolean infoBasedAccept = serviceInfo == null || creator.getServiceInfoType().isAssignableFrom(serviceInfo.getClass());
        return typeBasedAccept && infoBasedAccept;
    }

    private <SC, SI extends ServiceInfo> ServiceConnectorCreator<SC, SI> getServiceCreatorOrNull(Class<SC> serviceConnectorType, SI serviceInfo) {
        for (ServiceConnectorCreator<?, ? extends ServiceInfo> serviceConnectorCreator : this.serviceConnectorCreators) {
            logger.fine("Trying connector creator type " + serviceConnectorCreator);
            if (!this.accept(serviceConnectorCreator, serviceConnectorType, serviceInfo)) continue;
            return serviceConnectorCreator;
        }
        return null;
    }
}

