/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.watcher;

import java.util.UUID;
import org.casbin.jcasbin.persist.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisWatcher
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(RedisWatcher.class);
    private Runnable updateCallback;
    private StringRedisTemplate stringRedisTemplate;
    private static final String REDIS_WATCHER_UUID = UUID.randomUUID().toString();

    public RedisWatcher(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
        logger.info("Current casbin redis watcher uuid: {}", (Object)REDIS_WATCHER_UUID);
    }

    public void setUpdateCallback(Runnable runnable) {
        this.updateCallback = runnable;
    }

    public void update() {
        this.stringRedisTemplate.convertAndSend("CASBIN_POLICY_TOPIC", (Object)("Casbin policy has a new version from redis watcher: " + REDIS_WATCHER_UUID));
    }

    public void updatePolicy(String message) {
        if (message.contains(REDIS_WATCHER_UUID)) {
            logger.info("This casbin policy update notification comes from the current redis watcher instance: {}", (Object)REDIS_WATCHER_UUID);
            return;
        }
        logger.info(message);
        this.updateCallback.run();
        logger.info("Casbin policy updated.");
    }
}

