/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.util.Collection;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredWebOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.RequestPredicateFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class WebEndpointDiscoverer
extends EndpointDiscoverer<ExposableWebEndpoint, WebOperation>
implements WebEndpointsSupplier {
    private final PathMapper endpointPathMapper;
    private final RequestPredicateFactory requestPredicateFactory;

    public WebEndpointDiscoverer(ApplicationContext applicationContext, ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, PathMapper endpointPathMapper, Collection<OperationInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<ExposableWebEndpoint>> filters) {
        super(applicationContext, parameterValueMapper, invokerAdvisors, filters);
        Assert.notNull((Object)endpointPathMapper, (String)"EndpointPathMapper must not be null");
        this.endpointPathMapper = endpointPathMapper;
        this.requestPredicateFactory = new RequestPredicateFactory(endpointMediaTypes);
    }

    @Override
    @Deprecated
    protected ExposableWebEndpoint createEndpoint(Object endpointBean, String id, boolean enabledByDefault, Collection<WebOperation> operations) {
        return this.createEndpoint(endpointBean, EndpointId.of(id), enabledByDefault, (Collection)operations);
    }

    @Override
    protected ExposableWebEndpoint createEndpoint(Object endpointBean, EndpointId id, boolean enabledByDefault, Collection<WebOperation> operations) {
        String rootPath = this.endpointPathMapper.getRootPath(id);
        return new DiscoveredWebEndpoint(this, endpointBean, id, rootPath, enabledByDefault, operations);
    }

    @Override
    @Deprecated
    protected WebOperation createOperation(String endpointId, DiscoveredOperationMethod operationMethod, OperationInvoker invoker) {
        return this.createOperation(EndpointId.of(endpointId), operationMethod, invoker);
    }

    @Override
    protected WebOperation createOperation(EndpointId endpointId, DiscoveredOperationMethod operationMethod, OperationInvoker invoker) {
        String rootPath = this.endpointPathMapper.getRootPath(endpointId);
        WebOperationRequestPredicate requestPredicate = this.requestPredicateFactory.getRequestPredicate(endpointId, rootPath, operationMethod);
        return new DiscoveredWebOperation(endpointId, operationMethod, invoker, requestPredicate);
    }

    @Override
    protected EndpointDiscoverer.OperationKey createOperationKey(WebOperation operation) {
        return new EndpointDiscoverer.OperationKey(operation.getRequestPredicate(), () -> "web request predicate " + operation.getRequestPredicate());
    }
}

