/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.ResponseHeaders;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerResponseMessageReader(TypeNameExtractor typeNameExtractor, TypeResolver typeResolver) {
        this.typeNameExtractor = typeNameExtractor;
        this.typeResolver = typeResolver;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().responseMessages(this.read(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<ResponseMessage> read(OperationContext context) {
        ResolvedType defaultResponse = context.getReturnType();
        Optional operationAnnotation = context.findAnnotation(ApiOperation.class);
        Optional operationResponse = operationAnnotation.transform(Annotations.resolvedTypeFromOperation(this.typeResolver, defaultResponse));
        Optional defaultResponseHeaders = operationAnnotation.transform(ResponseHeaders.responseHeaders());
        HashMap defaultHeaders = Maps.newHashMap();
        if (defaultResponseHeaders.isPresent()) {
            defaultHeaders.putAll(ResponseHeaders.headers((ResponseHeader[])defaultResponseHeaders.get()));
        }
        List allApiResponses = context.findAllAnnotations(ApiResponses.class);
        HashSet responseMessages = Sets.newHashSet();
        HashMap seenResponsesByCode = Maps.newHashMap();
        for (ApiResponses apiResponses : allApiResponses) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = apiResponses.value()) {
                if (seenResponsesByCode.containsKey(apiResponse.code())) continue;
                seenResponsesByCode.put(apiResponse.code(), apiResponse);
                ModelContext modelContext = ModelContext.returnValue((String)context.getGroupName(), (Type)apiResponse.response(), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericsNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
                Optional responseModel = Optional.absent();
                Optional type = this.resolvedType(null, apiResponse);
                if (SwaggerResponseMessageReader.isSuccessful(apiResponse.code())) {
                    type = type.or(operationResponse);
                }
                if (type.isPresent()) {
                    responseModel = Optional.of((Object)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.typeNameExtractor).apply((Object)context.alternateFor((ResolvedType)type.get())));
                }
                HashMap headers = Maps.newHashMap((Map)defaultHeaders);
                headers.putAll(ResponseHeaders.headers(apiResponse.responseHeaders()));
                responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel((ModelReference)responseModel.orNull()).headersWithDescription((Map)headers).build());
            }
        }
        if (operationResponse.isPresent()) {
            ModelContext modelContext = ModelContext.returnValue((String)context.getGroupName(), (Type)((Type)operationResponse.get()), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericsNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
            ResolvedType resolvedType = context.alternateFor((ResolvedType)operationResponse.get());
            ModelReference responseModel = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.typeNameExtractor).apply((Object)resolvedType);
            context.operationBuilder().responseModel(responseModel);
            ResponseMessage defaultMessage = new ResponseMessageBuilder().code(ResponseMessagesReader.httpStatusCode((OperationContext)context)).message(ResponseMessagesReader.message((OperationContext)context)).responseModel(responseModel).build();
            if (!responseMessages.contains(defaultMessage) && !"void".equals(responseModel.getType())) {
                responseMessages.add(defaultMessage);
            }
        }
        return responseMessages;
    }

    static boolean isSuccessful(int code) {
        try {
            return HttpStatus.Series.SUCCESSFUL.equals((Object)HttpStatus.Series.valueOf((int)code));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private Optional<ResolvedType> resolvedType(ResolvedType resolvedType, ApiResponse apiResponse) {
        return Optional.fromNullable((Object)Annotations.resolvedTypeFromResponse(this.typeResolver, resolvedType).apply((Object)apiResponse));
    }
}

