/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure;

import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.spring.boot.autoconfigure.CasbinAutoConfiguration;
import org.casbin.spring.boot.autoconfigure.properties.CasbinProperties;
import org.casbin.watcher.RedisWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@EnableConfigurationProperties(value={CasbinProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class, CasbinAutoConfiguration.class})
@ConditionalOnExpression(value="'jdbc'.equalsIgnoreCase('${casbin.storeType:jdbc}') && ${casbin.enableWatcher:false} && 'redis'.equalsIgnoreCase('${casbin.watcherType:redis}') ")
public class CasbinRedisWatcherAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CasbinRedisWatcherAutoConfiguration.class);
    public static final String CASBIN_POLICY_TOPIC = "CASBIN_POLICY_TOPIC";

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    @ConditionalOnMissingBean
    public Watcher redisWatcher(StringRedisTemplate stringRedisTemplate, Enforcer enforcer) {
        RedisWatcher watcher = new RedisWatcher(stringRedisTemplate);
        enforcer.setWatcher((Watcher)watcher);
        logger.info("Casbin set watcher: {}", (Object)watcher.getClass().getName());
        return watcher;
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageListenerAdapter messageListenerAdapter(Watcher receiver) {
        return new MessageListenerAdapter((Object)receiver, "updatePolicy");
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new ChannelTopic(CASBIN_POLICY_TOPIC));
        return container;
    }
}

