/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.inline;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;

public enum StandardInlineMode {
    NONE,
    HTML,
    XML,
    TEXT,
    JAVASCRIPT,
    CSS;

    private static final Logger LOGGER;

    public static StandardInlineMode parse(String mode) {
        if (mode == null || mode.trim().length() == 0) {
            throw new IllegalArgumentException("Inline mode cannot be null or empty");
        }
        if ("NONE".equalsIgnoreCase(mode)) {
            return NONE;
        }
        if ("HTML".equalsIgnoreCase(mode)) {
            return HTML;
        }
        if ("XML".equalsIgnoreCase(mode)) {
            return XML;
        }
        if ("TEXT".equalsIgnoreCase(mode)) {
            return TEXT;
        }
        if ("JAVASCRIPT".equalsIgnoreCase(mode)) {
            return JAVASCRIPT;
        }
        if ("CSS".equalsIgnoreCase(mode)) {
            return CSS;
        }
        if (StandardInlineMode.checkDartInline(mode)) {
            return JAVASCRIPT;
        }
        throw new IllegalArgumentException("Unrecognized inline mode: " + mode);
    }

    @Deprecated
    private static boolean checkDartInline(String inliner) {
        if ("DART".equalsIgnoreCase(inliner)) {
            LOGGER.warn("[THYMELEAF][{}] Found inline call with value \"dart\", which has been deprecated as no corresponding template mode exists for it. Inline will be redirected to \"javascript\", which should now be used instead. This redirection will be removed in future versions of Thymeleaf.", (Object)TemplateEngine.threadIndex());
            return true;
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(StandardInlineMode.class);
    }
}

