/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.util.Assert;

public class ElasticsearchRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<ElasticsearchOperations> elasticsearchOperationsBean;

    public ElasticsearchRepositoryBean(Bean<ElasticsearchOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.of(detector));
        Assert.notNull(operations, (String)"Cannot create repository with 'null' for ElasticsearchOperations.");
        this.elasticsearchOperationsBean = operations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        ElasticsearchOperations elasticsearchOperations = (ElasticsearchOperations)this.getDependencyInstance(this.elasticsearchOperationsBean, ElasticsearchOperations.class);
        ElasticsearchRepositoryFactory factory = new ElasticsearchRepositoryFactory(elasticsearchOperations);
        return (T)customImplementation.map(o -> factory.getRepository(repositoryType, o)).orElseGet(() -> factory.getRepository(repositoryType));
    }

    public Class<? extends Annotation> getScope() {
        return this.elasticsearchOperationsBean.getScope();
    }
}

