/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.env.Environment;

public class DescriptionResolver {
    private static final Pattern pattern = Pattern.compile("\\Q${\\E(.+?)\\Q}\\E");
    private final Environment environment;
    private Map<String, String> cache;

    public DescriptionResolver(Environment environment) {
        this.environment = environment;
        this.cache = new HashMap<String, String>();
    }

    public String resolve(String expression) {
        String key;
        String value;
        if (Strings.isNullOrEmpty((String)expression)) {
            return expression;
        }
        if (this.cache.containsKey(expression)) {
            return this.cache.get(expression);
        }
        if (!expression.startsWith("$")) {
            this.cache.put(expression, expression);
            return expression;
        }
        Matcher matcher = pattern.matcher(expression);
        if (matcher.find() && (value = this.environment.getProperty(key = matcher.group(1))) != null) {
            this.cache.put(expression, value);
            return value;
        }
        this.cache.put(expression, expression);
        return expression;
    }
}

