/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private final File sourceDir;
    private final File outputFile;

    public Zipper(File sourceDir, File outputFile) {
        this.sourceDir = sourceDir;
        this.outputFile = outputFile;
        if (!this.outputFile.delete()) {
            throw new IllegalArgumentException("Can't delete outputfile " + outputFile.getAbsolutePath());
        }
    }

    public static void main(String[] args) throws IOException {
        File sourceDir = Zipper.getSourceDir(args);
        File outputFile = new File(System.getProperty("user.home") + File.separator + sourceDir.getName() + ".zip");
        new Zipper(sourceDir, outputFile).zipDirectory();
        System.out.println("Created zip file " + outputFile.getPath());
    }

    public File zipDirectory() throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]));){
            Zipper.recurseAndZip(this.sourceDir, zos);
            File file = this.outputFile;
            return file;
        }
    }

    private static void recurseAndZip(File file, ZipOutputStream zos) throws IOException {
        block15: {
            block14: {
                if (!file.isDirectory()) break block14;
                File[] files = file.listFiles();
                if (files == null) break block15;
                for (File f : files) {
                    Zipper.recurseAndZip(f, zos);
                }
                break block15;
            }
            byte[] buf = new byte[1024];
            ZipEntry entry = new ZipEntry(file.getName());
            try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                int len;
                zos.putNextEntry(entry);
                while ((len = bis.read(buf)) >= 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    private static File getSourceDir(String[] args) {
        String sourceDirPath;
        File sourceDir;
        if (args.length != 1) {
            Zipper.usageAndExit("Need directory name containing input files to render.");
        }
        if (!(sourceDir = new File(sourceDirPath = args[0])).exists()) {
            Zipper.usageAndExit(sourceDirPath);
        }
        return sourceDir;
    }

    private static void usageAndExit(String msg) {
        System.err.println("Source directory not found: " + msg);
        System.exit(-1);
    }
}

