/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorNameFactory;
import org.springframework.util.Assert;

public class CompositeHealthIndicatorFactory {
    private final Function<String, String> healthIndicatorNameFactory;

    public CompositeHealthIndicatorFactory(Function<String, String> healthIndicatorNameFactory) {
        this.healthIndicatorNameFactory = healthIndicatorNameFactory;
    }

    public CompositeHealthIndicatorFactory() {
        this(new HealthIndicatorNameFactory());
    }

    public CompositeHealthIndicator createHealthIndicator(HealthAggregator healthAggregator, Map<String, HealthIndicator> healthIndicators) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        Assert.notNull(healthIndicators, (String)"HealthIndicators must not be null");
        CompositeHealthIndicator healthIndicator = new CompositeHealthIndicator(healthAggregator);
        for (Map.Entry<String, HealthIndicator> entry : healthIndicators.entrySet()) {
            String name = this.healthIndicatorNameFactory.apply(entry.getKey());
            healthIndicator.addHealthIndicator(name, entry.getValue());
        }
        return healthIndicator;
    }
}

