/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.xml;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.cloud.config.CloudScanHelper;
import org.springframework.cloud.config.xml.CloudCassandraSessionParser;
import org.springframework.cloud.config.xml.CloudDataSourceFactoryParser;
import org.springframework.cloud.config.xml.CloudMongoDbFactoryParser;
import org.springframework.cloud.config.xml.CloudPropertiesFactoryBean;
import org.springframework.cloud.config.xml.CloudRabbitConnectionFactoryParser;
import org.springframework.cloud.config.xml.CloudRedisConnectionFactoryParser;
import org.springframework.cloud.config.xml.ConnectionPropertiesParser;
import org.springframework.cloud.config.xml.GenericCloudServiceFactoryParser;
import org.w3c.dom.Element;

public class CloudNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("service", (BeanDefinitionParser)new GenericCloudServiceFactoryParser());
        this.registerBeanDefinitionParser("rabbit-connection-factory", (BeanDefinitionParser)new CloudRabbitConnectionFactoryParser());
        this.registerBeanDefinitionParser("redis-connection-factory", (BeanDefinitionParser)new CloudRedisConnectionFactoryParser());
        this.registerBeanDefinitionParser("mongo-db-factory", (BeanDefinitionParser)new CloudMongoDbFactoryParser());
        this.registerBeanDefinitionParser("data-source", (BeanDefinitionParser)new CloudDataSourceFactoryParser());
        this.registerBeanDefinitionParser("cassandra-session-factory", (BeanDefinitionParser)new CloudCassandraSessionParser());
        this.registerBeanDefinitionParser("connection-properties", (BeanDefinitionParser)new ConnectionPropertiesParser());
        this.registerBeanDefinitionParser("properties", (BeanDefinitionParser)new AbstractSimpleBeanDefinitionParser(){

            protected Class<?> getBeanClass(Element element) {
                return CloudPropertiesFactoryBean.class;
            }
        });
        this.registerBeanDefinitionParser("service-scan", (BeanDefinitionParser)new AbstractSimpleBeanDefinitionParser(){

            protected Class<?> getBeanClass(Element element) {
                return ServiceScanBeanFactoryProcessor.class;
            }

            protected boolean shouldGenerateId() {
                return true;
            }
        });
    }

    public static class ServiceScanBeanFactoryProcessor
    implements BeanFactoryPostProcessor {
        private CloudScanHelper helper = new CloudScanHelper();

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.helper.registerServiceBeans((BeanDefinitionRegistry)beanFactory);
        }
    }
}

