/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.distribution;

import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.NavigableSet;
import java.util.TreeSet;

public class PercentileHistogramBuckets {
    private static final int DIGITS = 2;
    private static final NavigableSet<Long> PERCENTILE_BUCKETS = new TreeSet<Long>();

    public static NavigableSet<Long> buckets(DistributionStatisticConfig distributionStatisticConfig) {
        return PERCENTILE_BUCKETS.subSet(distributionStatisticConfig.getMinimumExpectedValue(), true, distributionStatisticConfig.getMaximumExpectedValue(), true);
    }

    static {
        PERCENTILE_BUCKETS.add(1L);
        PERCENTILE_BUCKETS.add(2L);
        PERCENTILE_BUCKETS.add(3L);
        for (int exp = 2; exp < 64; exp += 2) {
            long current;
            long delta = current / 3L;
            long next = (current << 2) - delta;
            for (current = 1L << exp; current < next; current += delta) {
                PERCENTILE_BUCKETS.add(current);
            }
        }
        PERCENTILE_BUCKETS.add(Long.MAX_VALUE);
    }
}

