/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.adapter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.casbin.adapter.CasbinRule;
import org.casbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.spring.boot.autoconfigure.properties.CasbinExceptionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

public class JdbcAdapter
implements Adapter {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAdapter.class);
    private static final String INIT_TABLE_SQL = "CREATE TABLE IF NOT EXISTS casbin_rule (    ptype varchar(255) NOT NULL,    v0    varchar(255) DEFAULT NULL,    v1    varchar(255) DEFAULT NULL,    v2    varchar(255) DEFAULT NULL,    v3    varchar(255) DEFAULT NULL,    v4    varchar(255) DEFAULT NULL,    v5    varchar(255) DEFAULT NULL)";
    private static final String DROP_TABLE_SQL = "DROP TABLE IF EXISTS casbin_rule";
    private static final String DELETE_TABLE_CONTENT_SQL = "DELETE FROM casbin_rule";
    private static final String LOAD_POLICY_SQL = "SELECT * FROM casbin_rule";
    private static final String INSERT_POLICY_SQL = "INSERT INTO casbin_rule VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_POLICY_SQL = "DELETE FROM casbin_rule WHERE ptype = ? ";
    protected JdbcTemplate jdbcTemplate;
    protected CasbinExceptionProperties casbinExceptionProperties;

    public JdbcAdapter(JdbcTemplate jdbcTemplate, CasbinExceptionProperties casbinExceptionProperties, boolean autoCreateTable) {
        this.jdbcTemplate = jdbcTemplate;
        this.casbinExceptionProperties = casbinExceptionProperties;
        if (autoCreateTable) {
            this.initTable();
        }
    }

    protected String getInitTableSql() {
        return INIT_TABLE_SQL;
    }

    protected String getDropTableSql() {
        return DROP_TABLE_SQL;
    }

    protected String getLoadPolicySql() {
        return LOAD_POLICY_SQL;
    }

    protected String getDeleteTableContentSql() {
        return DELETE_TABLE_CONTENT_SQL;
    }

    protected void initTable() {
        this.jdbcTemplate.execute(this.getInitTableSql());
    }

    protected void dropTable() {
        this.jdbcTemplate.execute(this.getDropTableSql());
    }

    protected void deleteTableContent() {
        this.jdbcTemplate.execute(this.getDeleteTableContentSql());
    }

    @Transactional(readOnly=true)
    public void loadPolicy(Model model) {
        List casbinRules = this.jdbcTemplate.query(this.getLoadPolicySql(), (RowMapper)BeanPropertyRowMapper.newInstance(CasbinRule.class));
        Map<String, List> policies = casbinRules.parallelStream().distinct().map(CasbinRule::toPolicy).collect(Collectors.toMap(x -> (String)x.get(0), y -> {
            ArrayList<ArrayList> lists = new ArrayList<ArrayList>();
            y.remove(0);
            lists.add((ArrayList)y);
            return lists;
        }, (oldValue, newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        }));
        policies.keySet().forEach(k -> ((Assertion)((Map)model.model.get((Object)k.substring((int)0, (int)1))).get((Object)k)).policy.addAll((Collection)policies.get(k)));
    }

    @Transactional
    public void savePolicy(Model model) {
        this.deleteTableContent();
        final List<CasbinRule> casbinRules = CasbinRule.transformToCasbinRule(model);
        int[] rows = this.jdbcTemplate.batchUpdate(INSERT_POLICY_SQL, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, ((CasbinRule)casbinRules.get(i)).getPtype());
                ps.setString(2, ((CasbinRule)casbinRules.get(i)).getV0());
                ps.setString(3, ((CasbinRule)casbinRules.get(i)).getV1());
                ps.setString(4, ((CasbinRule)casbinRules.get(i)).getV2());
                ps.setString(5, ((CasbinRule)casbinRules.get(i)).getV3());
                ps.setString(6, ((CasbinRule)casbinRules.get(i)).getV4());
                ps.setString(7, ((CasbinRule)casbinRules.get(i)).getV5());
            }

            public int getBatchSize() {
                return casbinRules.size();
            }
        });
        int insertRows = 0;
        for (int row : rows) {
            insertRows += row;
        }
        if (insertRows != casbinRules.size()) {
            throw new CasbinAdapterException(String.format("Add policy error, add %d rows, expect %d rows", insertRows, casbinRules.size()));
        }
    }

    @Transactional
    public void addPolicy(String sec, String ptype, List<String> rule) {
        ArrayList<String> rules = new ArrayList<String>(rule);
        rules.add(0, ptype);
        for (int i = 0; i < 6 - rule.size(); ++i) {
            rules.add(null);
        }
        int rows = this.jdbcTemplate.update(INSERT_POLICY_SQL, rules.toArray());
        if (rows != 1) {
            throw new CasbinAdapterException(String.format("Add policy error, add %d rows, expect %d rows", rows, 1));
        }
    }

    @Transactional
    public void removePolicy(String sec, String ptype, List<String> rule) {
        if (rule.isEmpty()) {
            return;
        }
        this.removeFilteredPolicy(sec, ptype, 0, rule.toArray(new String[0]));
    }

    @Transactional
    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        if (fieldValues.length == 0) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(fieldValues));
        params.add(0, ptype);
        String delSql = DELETE_POLICY_SQL;
        int columnIndex = fieldIndex;
        for (int i = 0; i < fieldValues.length; ++i) {
            delSql = String.format("%s%s%s%s", delSql, " AND v", columnIndex, " = ? ");
            ++columnIndex;
        }
        int rows = this.jdbcTemplate.update(delSql, params.toArray());
        if (rows < 1) {
            if (this.casbinExceptionProperties.isRemovePolicyFailed()) {
                throw new CasbinAdapterException(String.format("Remove filtered policy error, remove %d rows, expect least 1 rows", rows));
            }
            logger.warn(String.format("Remove filtered policy error, remove %d rows, expect least 1 rows", rows));
        }
    }
}

