/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedLongValues;

class NumericDocValuesWriter
extends DocValuesWriter {
    private static final long MISSING = 0L;
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private FixedBitSet docsWithField = new FixedBitSet(64);
    private final FieldInfo fieldInfo;
    PackedLongValues finalValues;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if ((long)docID < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        for (int i = (int)this.pending.size(); i < docID; ++i) {
            this.pending.add(0L);
        }
        this.pending.add(value);
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, docID);
        this.docsWithField.set(docID);
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void finish(int maxDoc) {
        this.finalValues = this.pending.build();
    }

    @Override
    public void flush(SegmentWriteState state, final Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.maxDoc();
        dvConsumer.addNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                if (sortMap == null) {
                    return new NumericIterator(maxDoc, NumericDocValuesWriter.this.finalValues, NumericDocValuesWriter.this.docsWithField);
                }
                return new SortingNumericIterator(maxDoc, NumericDocValuesWriter.this.finalValues, NumericDocValuesWriter.this.docsWithField, sortMap);
            }
        });
    }

    @Override
    Sorter.DocComparator getDocComparator(int numDoc, SortField sortField) throws IOException {
        return NumericDocValuesWriter.getDocComparator(sortField, sortField.getType(), docID -> docID < this.docsWithField.length() ? this.docsWithField.get(docID) : false, docID -> this.finalValues.get(docID));
    }

    static Sorter.DocComparator getDocComparator(SortField sortField, SortField.Type sortType, IntPredicate docsWithField, IntToLongFunction docValueFunction) {
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        switch (sortType) {
            case LONG: {
                long missingValue = sortField.getMissingValue() != null ? (Long)sortField.getMissingValue() : 0L;
                final IntToLongFunction docValueOrMissing = docID -> docsWithField.test(docID) ? docValueFunction.applyAsLong(docID) : missingValue;
                return new Sorter.DocComparator(){

                    @Override
                    public int compare(int docID1, int docID2) {
                        long value1 = docValueOrMissing.applyAsLong(docID1);
                        long value2 = docValueOrMissing.applyAsLong(docID2);
                        return reverseMul * Long.compare(value1, value2);
                    }
                };
            }
            case INT: {
                int missingValue = sortField.getMissingValue() != null ? (Integer)sortField.getMissingValue() : 0;
                final IntToLongFunction docValueOrMissing = docID -> docsWithField.test(docID) ? docValueFunction.applyAsLong(docID) : (long)missingValue;
                return new Sorter.DocComparator(){

                    @Override
                    public int compare(int docID1, int docID2) {
                        int value1 = (int)docValueOrMissing.applyAsLong(docID1);
                        int value2 = (int)docValueOrMissing.applyAsLong(docID2);
                        return reverseMul * Integer.compare(value1, value2);
                    }
                };
            }
            case DOUBLE: {
                double missingValue = sortField.getMissingValue() != null ? (Double)sortField.getMissingValue() : 0.0;
                final IntToDoubleFunction docValueOrMissing = docID -> docsWithField.test(docID) ? Double.longBitsToDouble(docValueFunction.applyAsLong(docID)) : missingValue;
                return new Sorter.DocComparator(){

                    @Override
                    public int compare(int docID1, int docID2) {
                        double value1 = docValueOrMissing.applyAsDouble(docID1);
                        double value2 = docValueOrMissing.applyAsDouble(docID2);
                        return reverseMul * Double.compare(value1, value2);
                    }
                };
            }
            case FLOAT: {
                float missingValue = sortField.getMissingValue() != null ? ((Float)sortField.getMissingValue()).floatValue() : 0.0f;
                final IntToDoubleFunction docValueOrMissing = docID -> docsWithField.test(docID) ? (double)Float.intBitsToFloat((int)docValueFunction.applyAsLong(docID)) : (double)missingValue;
                return new Sorter.DocComparator(){

                    @Override
                    public int compare(int docID1, int docID2) {
                        float value1 = (float)docValueOrMissing.applyAsDouble(docID1);
                        float value2 = (float)docValueOrMissing.applyAsDouble(docID2);
                        return reverseMul * Float.compare(value1, value2);
                    }
                };
            }
        }
        throw new IllegalArgumentException("unhandled SortField.getType()=" + (Object)((Object)sortField.getType()));
    }

    private static class SortingNumericIterator
    implements Iterator<Number> {
        final PackedLongValues values;
        final FixedBitSet docsWithField;
        final Sorter.DocMap sortMap;
        final int size;
        final int maxDoc;
        int upto;

        SortingNumericIterator(int maxDoc, PackedLongValues values, FixedBitSet docsWithFields, Sorter.DocMap sortMap) {
            this.maxDoc = maxDoc;
            this.values = values;
            this.size = (int)values.size();
            this.docsWithField = docsWithFields;
            this.sortMap = sortMap;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int old = this.sortMap.newToOld(this.upto);
            Long value = old < this.size && this.docsWithField.get(old) ? Long.valueOf(this.values.get(old)) : null;
            ++this.upto;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NumericIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final FixedBitSet docsWithField;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int maxDoc, PackedLongValues values, FixedBitSet docsWithFields) {
            this.maxDoc = maxDoc;
            this.iter = values.iterator();
            this.size = (int)values.size();
            this.docsWithField = docsWithFields;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            Long value;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                long v = this.iter.next();
                value = this.docsWithField.get(this.upto) ? Long.valueOf(v) : null;
            } else {
                value = null;
            }
            ++this.upto;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

