/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class FieldCapabilitiesIndexResponse
extends ActionResponse
implements Writeable {
    private String indexName;
    private Map<String, FieldCapabilities> responseMap;

    FieldCapabilitiesIndexResponse(String indexName, Map<String, FieldCapabilities> responseMap) {
        this.indexName = indexName;
        this.responseMap = responseMap;
    }

    FieldCapabilitiesIndexResponse() {
    }

    FieldCapabilitiesIndexResponse(StreamInput input) throws IOException {
        this.readFrom(input);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Map<String, FieldCapabilities> get() {
        return this.responseMap;
    }

    public FieldCapabilities getField(String field) {
        return this.responseMap.get(field);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indexName = in.readString();
        this.responseMap = in.readMap(StreamInput::readString, FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.indexName);
        out.writeMap(this.responseMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)o;
        return this.responseMap.equals(that.responseMap);
    }

    public int hashCode() {
        return this.responseMap.hashCode();
    }
}

