/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import com.google.common.base.Optional;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterNotNullAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterNotNullAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterExpansionContext context) {
        Optional notNull = context.findAnnotation(NotNull.class);
        if (notNull.isPresent()) {
            LOG.debug("Setting parameter to required because of @NotNull attribute");
            context.getParameterBuilder().required(true);
        }
    }
}

