/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ehcache.Cache;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;

final class StatsUtils {
    private StatsUtils() {
    }

    static Matcher<Map<String, Object>> hasTag(final String tag) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.contains(tag);
            }
        });
    }

    static Matcher<Map<String, Object>> hasProperty(final String key, final String value) {
        return Matchers.hasAttribute("properties", (Matcher<? extends Object>)new Matcher<Map<String, Object>>(){

            @Override
            protected boolean matchesSafely(Map<String, Object> properties) {
                Object val = properties.get(key);
                return val != null && value.equals(val);
            }
        });
    }

    static <T> Optional<T> findStatisticOnDescendants(Object context, String discriminator, String tag, String statName) {
        Set<TreeNode> statResult = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", statName), StatsUtils.hasProperty("discriminator", discriminator), StatsUtils.hasTag(tag))))).build().execute(Collections.singleton(ContextManager.nodeFor(context)));
        if (statResult.size() > 1) {
            throw new RuntimeException("One stat expected for " + statName + " but found " + statResult.size());
        }
        if (statResult.size() == 1) {
            Object result = statResult.iterator().next().getContext().attributes().get("this");
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    static <T> Optional<T> findStatisticOnDescendants(Object context, String tag, String statName) {
        Set<TreeNode> statResult = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", statName), StatsUtils.hasTag(tag))))).build().execute(Collections.singleton(ContextManager.nodeFor(context)));
        if (statResult.size() > 1) {
            throw new RuntimeException("One stat expected for " + statName + " but found " + statResult.size());
        }
        if (statResult.size() == 1) {
            Object result = statResult.iterator().next().getContext().attributes().get("this");
            return Optional.ofNullable(result);
        }
        return Optional.empty();
    }

    static <T extends Enum<T>> OperationStatistic<T> findOperationStatisticOnChildren(Object context, Class<T> type, String statName) {
        Query query = QueryBuilder.queryBuilder().children().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", statName), Matchers.hasAttribute("type", type))))).build();
        Set<TreeNode> result = query.execute(Collections.singleton(ContextManager.nodeFor(context)));
        if (result.size() > 1) {
            throw new RuntimeException("result must be unique");
        }
        if (result.isEmpty()) {
            throw new RuntimeException("result must not be null");
        }
        OperationStatistic statistic = (OperationStatistic)result.iterator().next().getContext().attributes().get("this");
        return statistic;
    }

    static String[] findTiers(Cache<?, ?> cache) {
        Query statQuery = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", "eviction"), Matchers.hasAttribute("type", StoreOperationOutcomes.EvictionOutcome.class))))).build();
        Set<TreeNode> statResult = statQuery.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (statResult.isEmpty()) {
            throw new RuntimeException("Failed to find tiers using the eviction observer, valid result Set sizes must 1 or more");
        }
        String[] tiers = new String[statResult.size()];
        int i = 0;
        for (TreeNode treeNode : statResult) {
            Set tags = (Set)treeNode.getContext().attributes().get("tags");
            if (tags.size() != 1) {
                throw new RuntimeException("We expect tiers to have only one tag");
            }
            String storeType = tags.iterator().next().toString();
            tiers[i++] = storeType;
        }
        return tiers;
    }

    static String findLowestTier(String[] tiers) {
        if (tiers.length == 1) {
            return tiers[0];
        }
        if (tiers.length == 0) {
            throw new RuntimeException("No existing tier");
        }
        String lowestTier = tiers[0];
        for (int i = 1; i < tiers.length; ++i) {
            if (tiers[i].compareTo(lowestTier) >= 0) continue;
            lowestTier = tiers[i];
        }
        return lowestTier;
    }
}

