/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Cluster.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    private final CassandraProperties properties;
    private final List<ClusterBuilderCustomizer> builderCustomizers;

    public CassandraAutoConfiguration(CassandraProperties properties, ObjectProvider<List<ClusterBuilderCustomizer>> builderCustomizers) {
        this.properties = properties;
        this.builderCustomizers = (List)builderCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public Cluster cassandraCluster() {
        PropertyMapper map = PropertyMapper.get();
        CassandraProperties properties = this.properties;
        Cluster.Builder builder = Cluster.builder().withClusterName(properties.getClusterName()).withPort(properties.getPort());
        map.from(properties::getUsername).whenNonNull().to(username -> builder.withCredentials(username, properties.getPassword()));
        map.from(properties::getCompression).whenNonNull().to(arg_0 -> ((Cluster.Builder)builder).withCompression(arg_0));
        map.from(properties::getLoadBalancingPolicy).whenNonNull().as(BeanUtils::instantiateClass).to(arg_0 -> ((Cluster.Builder)builder).withLoadBalancingPolicy(arg_0));
        map.from(this::getQueryOptions).to(arg_0 -> ((Cluster.Builder)builder).withQueryOptions(arg_0));
        map.from(properties::getReconnectionPolicy).whenNonNull().as(BeanUtils::instantiateClass).to(arg_0 -> ((Cluster.Builder)builder).withReconnectionPolicy(arg_0));
        map.from(properties::getRetryPolicy).whenNonNull().as(BeanUtils::instantiateClass).to(arg_0 -> ((Cluster.Builder)builder).withRetryPolicy(arg_0));
        map.from(this::getSocketOptions).to(arg_0 -> ((Cluster.Builder)builder).withSocketOptions(arg_0));
        map.from(properties::isSsl).whenTrue().toCall(() -> ((Cluster.Builder)builder).withSSL());
        map.from(this::getPoolingOptions).to(arg_0 -> ((Cluster.Builder)builder).withPoolingOptions(arg_0));
        map.from(properties::getContactPoints).as(list -> StringUtils.toStringArray((Collection)list)).to(arg_0 -> ((Cluster.Builder)builder).addContactPoints(arg_0));
        this.customize(builder);
        return builder.build();
    }

    private void customize(Cluster.Builder builder) {
        if (this.builderCustomizers != null) {
            for (ClusterBuilderCustomizer customizer : this.builderCustomizers) {
                customizer.customize(builder);
            }
        }
    }

    private QueryOptions getQueryOptions() {
        PropertyMapper map = PropertyMapper.get();
        QueryOptions options = new QueryOptions();
        CassandraProperties properties = this.properties;
        map.from(properties::getConsistencyLevel).whenNonNull().to(arg_0 -> ((QueryOptions)options).setConsistencyLevel(arg_0));
        map.from(properties::getSerialConsistencyLevel).whenNonNull().to(arg_0 -> ((QueryOptions)options).setSerialConsistencyLevel(arg_0));
        map.from(properties::getFetchSize).to(arg_0 -> ((QueryOptions)options).setFetchSize(arg_0));
        return options;
    }

    private SocketOptions getSocketOptions() {
        PropertyMapper map = PropertyMapper.get();
        SocketOptions options = new SocketOptions();
        map.from(this.properties::getConnectTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((SocketOptions)options).setConnectTimeoutMillis(arg_0));
        map.from(this.properties::getReadTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((SocketOptions)options).setReadTimeoutMillis(arg_0));
        return options;
    }

    private PoolingOptions getPoolingOptions() {
        PropertyMapper map = PropertyMapper.get();
        CassandraProperties.Pool properties = this.properties.getPool();
        PoolingOptions options = new PoolingOptions();
        map.from(properties::getIdleTimeout).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((PoolingOptions)options).setIdleTimeoutSeconds(arg_0));
        map.from(properties::getPoolTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((PoolingOptions)options).setPoolTimeoutMillis(arg_0));
        map.from(properties::getHeartbeatInterval).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((PoolingOptions)options).setHeartbeatIntervalSeconds(arg_0));
        map.from(properties::getMaxQueueSize).to(arg_0 -> ((PoolingOptions)options).setMaxQueueSize(arg_0));
        return options;
    }
}

