/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.Env;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class LambdaFunction
extends AbstractFunction {
    protected List<String> arguments;
    protected Expression expression;
    protected Env context;

    public LambdaFunction(List<String> arguments, Expression expression, Env context) {
        this.arguments = arguments;
        this.context = context;
        HashSet<String> argumentSet = new HashSet<String>(this.arguments);
        for (String var : expression.getVariableNames()) {
            if (var.contains(".") || argumentSet.contains(var)) continue;
            context.capture(var, ((BaseExpression)expression).getExpression());
        }
        this.expression = expression;
    }

    protected Map<String, Object> newEnv(Map<String, Object> parentEnv, AviatorObject ... args) {
        Env env = new Env(new Env(parentEnv, this.context));
        env.setInstance(this.context.getInstance());
        int i = 0;
        for (String name : this.arguments) {
            env.put(name, args[i++].getValue(env));
        }
        return env;
    }
}

