/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import java.lang.reflect.Method;
import java.util.Arrays;

class MethodKey {
    private final String name;
    private final Class<?> returnType;
    private final Class<?>[] parameterTypes;
    private final int hashCode;

    public static MethodKey forMethod(Method method) {
        return new MethodKey(method);
    }

    private MethodKey(Method method) {
        this.name = method.getName();
        this.returnType = method.getReturnType();
        this.parameterTypes = method.getParameterTypes();
        this.hashCode = this.computeHashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + this.returnType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodKey other = (MethodKey)obj;
        return this.name.equals(other.name) && this.returnType.equals(other.returnType) && Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.returnType.getSimpleName());
        sb.append(' ');
        sb.append(this.name);
        sb.append('(');
        boolean firstParam = true;
        for (Class<?> parameterType : this.parameterTypes) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            sb.append(parameterType.getSimpleName());
        }
        sb.append(')');
        return sb.toString();
    }
}

