/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorCreationException;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.BasicDbcpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.cloud.service.relational.HikariCpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.PooledDataSourceCreator;
import org.springframework.cloud.service.relational.TomcatDbcpPooledDataSourceCreator;
import org.springframework.cloud.service.relational.TomcatJdbcPooledDataSourceCreator;
import org.springframework.cloud.service.relational.UrlDecodingDataSource;

public abstract class DataSourceCreator<SI extends RelationalServiceInfo>
extends AbstractServiceConnectorCreator<DataSource, SI> {
    protected static Logger logger = Logger.getLogger(DataSourceCreator.class.getName());
    private String driverSystemPropKey;
    private String[] driverClasses;
    private String validationQuery;
    private Map<String, PooledDataSourceCreator<SI>> pooledDataSourceCreators = new LinkedHashMap<String, PooledDataSourceCreator<SI>>();

    public DataSourceCreator(String driverSystemPropKey, String[] driverClasses, String validationQuery) {
        this.driverSystemPropKey = driverSystemPropKey;
        this.driverClasses = driverClasses;
        this.validationQuery = validationQuery;
        if (this.pooledDataSourceCreators.size() == 0) {
            this.putPooledDataSourceCreator(new TomcatJdbcPooledDataSourceCreator());
            this.putPooledDataSourceCreator(new HikariCpPooledDataSourceCreator());
            this.putPooledDataSourceCreator(new TomcatDbcpPooledDataSourceCreator());
            this.putPooledDataSourceCreator(new BasicDbcpPooledDataSourceCreator());
        }
    }

    private void putPooledDataSourceCreator(PooledDataSourceCreator<SI> pooledDataSourceCreator) {
        this.pooledDataSourceCreators.put(pooledDataSourceCreator.getClass().getSimpleName(), pooledDataSourceCreator);
    }

    public DataSource create(SI serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        try {
            DataSource ds = this.createPooledDataSource(serviceInfo, serviceConnectorConfig);
            if (ds != null) {
                return ds;
            }
            logger.warning("No connection pooling DataSource implementation found on the classpath - no pooling is in effect.");
            return new UrlDecodingDataSource(serviceInfo.getJdbcUrl());
        }
        catch (Exception e) {
            throw new ServiceConnectorCreationException("Failed to created cloud datasource for " + serviceInfo.getId() + " service", (Throwable)e);
        }
    }

    private DataSource createPooledDataSource(SI serviceInfo, ServiceConnectorConfig serviceConnectorConfig) {
        Collection<PooledDataSourceCreator<SI>> delegates = this.filterPooledDataSourceCreators(serviceConnectorConfig);
        for (PooledDataSourceCreator<SI> delegate : delegates) {
            DataSource ds = delegate.create((RelationalServiceInfo)serviceInfo, serviceConnectorConfig, this.getDriverClassName(serviceInfo), this.validationQuery);
            if (ds == null) continue;
            return ds;
        }
        return null;
    }

    private Collection<PooledDataSourceCreator<SI>> filterPooledDataSourceCreators(ServiceConnectorConfig serviceConnectorConfig) {
        List<String> pooledDataSourceNames;
        if (serviceConnectorConfig != null && (pooledDataSourceNames = ((DataSourceConfig)serviceConnectorConfig).getPooledDataSourceNames()) != null) {
            ArrayList<PooledDataSourceCreator<SI>> filtered = new ArrayList<PooledDataSourceCreator<SI>>();
            for (String name : pooledDataSourceNames) {
                for (String key : this.pooledDataSourceCreators.keySet()) {
                    if (!key.contains(name)) continue;
                    filtered.add(this.pooledDataSourceCreators.get(key));
                }
            }
            return filtered;
        }
        return this.pooledDataSourceCreators.values();
    }

    public String getDriverClassName(SI serviceInfo) {
        String userSpecifiedDriver = System.getProperty(this.driverSystemPropKey);
        if (userSpecifiedDriver != null && !userSpecifiedDriver.isEmpty()) {
            return userSpecifiedDriver;
        }
        for (String driver : this.driverClasses) {
            try {
                Class.forName(driver);
                return driver;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new CloudException("No suitable database driver found for " + serviceInfo.getId() + " service ");
    }
}

