/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import com.google.common.base.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterMinMaxAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterMinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterExpansionContext context) {
        Optional min = context.findAnnotation(Min.class);
        Optional max = context.findAnnotation(Max.class);
        if (min.isPresent() || max.isPresent()) {
            AllowableRangeValues values = RangeAnnotations.allowableRange((Optional<Min>)min, (Optional<Max>)max);
            LOG.debug("Adding allowable range: min({}) - max({}}", (Object)values.getMin(), (Object)values.getMax());
            context.getParameterBuilder().allowableValues((AllowableValues)values);
        }
    }
}

