/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;

class DocumentsWriterFlushQueue {
    private final Queue<FlushTicket> queue = new LinkedList<FlushTicket>();
    private final AtomicInteger ticketCount = new AtomicInteger();
    private final ReentrantLock purgeLock = new ReentrantLock();

    DocumentsWriterFlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeletes(DocumentsWriterDeleteQueue deleteQueue) throws IOException {
        DocumentsWriterFlushQueue documentsWriterFlushQueue = this;
        synchronized (documentsWriterFlushQueue) {
            this.incTickets();
            boolean success = false;
            try {
                this.queue.add(new GlobalDeletesTicket(deleteQueue.freezeGlobalBuffer(null)));
                success = true;
            }
            finally {
                if (!success) {
                    this.decTickets();
                }
            }
        }
    }

    private void incTickets() {
        int numTickets = this.ticketCount.incrementAndGet();
        assert (numTickets > 0);
    }

    private void decTickets() {
        int numTickets = this.ticketCount.decrementAndGet();
        assert (numTickets >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SegmentFlushTicket addFlushTicket(DocumentsWriterPerThread dwpt) {
        this.incTickets();
        boolean success = false;
        try {
            SegmentFlushTicket ticket = new SegmentFlushTicket(dwpt.prepareFlush());
            this.queue.add(ticket);
            success = true;
            SegmentFlushTicket segmentFlushTicket = ticket;
            return segmentFlushTicket;
        }
        finally {
            if (!success) {
                this.decTickets();
            }
        }
    }

    synchronized void addSegment(SegmentFlushTicket ticket, DocumentsWriterPerThread.FlushedSegment segment) {
        ticket.setSegment(segment);
    }

    synchronized void markTicketFailed(SegmentFlushTicket ticket) {
        ticket.setFailed();
    }

    boolean hasTickets() {
        assert (this.ticketCount.get() >= 0) : "ticketCount should be >= 0 but was: " + this.ticketCount.get();
        return this.ticketCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int innerPurge(IndexWriter writer) throws IOException {
        assert (this.purgeLock.isHeldByCurrentThread());
        int numPurged = 0;
        while (true) {
            boolean canPublish;
            FlushTicket head;
            DocumentsWriterFlushQueue documentsWriterFlushQueue = this;
            synchronized (documentsWriterFlushQueue) {
                head = this.queue.peek();
                canPublish = head != null && head.canPublish();
            }
            if (!canPublish) return numPurged;
            ++numPurged;
            try {
                head.publish(writer);
                continue;
            }
            finally {
                documentsWriterFlushQueue = this;
                synchronized (documentsWriterFlushQueue) {
                    FlushTicket poll = this.queue.poll();
                    this.ticketCount.decrementAndGet();
                    assert (poll == head);
                }
                continue;
            }
            break;
        }
    }

    int forcePurge(IndexWriter writer) throws IOException {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(writer));
        this.purgeLock.lock();
        try {
            int n = this.innerPurge(writer);
            return n;
        }
        finally {
            this.purgeLock.unlock();
        }
    }

    int tryPurge(IndexWriter writer) throws IOException {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(writer));
        if (this.purgeLock.tryLock()) {
            try {
                int n = this.innerPurge(writer);
                return n;
            }
            finally {
                this.purgeLock.unlock();
            }
        }
        return 0;
    }

    public int getTicketCount() {
        return this.ticketCount.get();
    }

    synchronized void clear() {
        this.queue.clear();
        this.ticketCount.set(0);
    }

    static final class SegmentFlushTicket
    extends FlushTicket {
        private DocumentsWriterPerThread.FlushedSegment segment;
        private boolean failed = false;

        protected SegmentFlushTicket(FrozenBufferedUpdates frozenDeletes) {
            super(frozenDeletes);
        }

        @Override
        protected void publish(IndexWriter writer) throws IOException {
            assert (!this.published) : "ticket was already publised - can not publish twice";
            this.published = true;
            this.finishFlush(writer, this.segment, this.frozenUpdates);
        }

        protected void setSegment(DocumentsWriterPerThread.FlushedSegment segment) {
            assert (!this.failed);
            this.segment = segment;
        }

        protected void setFailed() {
            assert (this.segment == null);
            this.failed = true;
        }

        @Override
        protected boolean canPublish() {
            return this.segment != null || this.failed;
        }
    }

    static final class GlobalDeletesTicket
    extends FlushTicket {
        protected GlobalDeletesTicket(FrozenBufferedUpdates frozenUpdates) {
            super(frozenUpdates);
        }

        @Override
        protected void publish(IndexWriter writer) throws IOException {
            assert (!this.published) : "ticket was already publised - can not publish twice";
            this.published = true;
            this.finishFlush(writer, null, this.frozenUpdates);
        }

        @Override
        protected boolean canPublish() {
            return true;
        }
    }

    static abstract class FlushTicket {
        protected FrozenBufferedUpdates frozenUpdates;
        protected boolean published = false;

        protected FlushTicket(FrozenBufferedUpdates frozenUpdates) {
            assert (frozenUpdates != null);
            this.frozenUpdates = frozenUpdates;
        }

        protected abstract void publish(IndexWriter var1) throws IOException;

        protected abstract boolean canPublish();

        protected final void publishFlushedSegment(IndexWriter indexWriter, DocumentsWriterPerThread.FlushedSegment newSegment, FrozenBufferedUpdates globalPacket) throws IOException {
            assert (newSegment != null);
            assert (newSegment.segmentInfo != null);
            FrozenBufferedUpdates segmentUpdates = newSegment.segmentUpdates;
            if (indexWriter.infoStream.isEnabled("DW")) {
                indexWriter.infoStream.message("DW", "publishFlushedSegment seg-private updates=" + segmentUpdates);
            }
            if (segmentUpdates != null && indexWriter.infoStream.isEnabled("DW")) {
                indexWriter.infoStream.message("DW", "flush: push buffered seg private updates: " + segmentUpdates);
            }
            indexWriter.publishFlushedSegment(newSegment.segmentInfo, segmentUpdates, globalPacket);
        }

        protected final void finishFlush(IndexWriter indexWriter, DocumentsWriterPerThread.FlushedSegment newSegment, FrozenBufferedUpdates bufferedUpdates) throws IOException {
            if (newSegment == null) {
                assert (bufferedUpdates != null);
                if (bufferedUpdates != null && bufferedUpdates.any()) {
                    indexWriter.publishFrozenUpdates(bufferedUpdates);
                    if (indexWriter.infoStream.isEnabled("DW")) {
                        indexWriter.infoStream.message("DW", "flush: push buffered updates: " + bufferedUpdates);
                    }
                }
            } else {
                this.publishFlushedSegment(indexWriter, newSegment, bufferedUpdates);
            }
        }
    }
}

