/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.util.StringUtils;

@DataTypeInfo(name="datetime", aliases={"java.sql.Types.DATETIME", "java.util.Date", "smalldatetime", "datetime2"}, minParameters=0, maxParameters=1, priority=1)
public class DateTimeType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        String originalDefinition = StringUtils.trimToEmpty(this.getRawDefinition());
        boolean allowFractional = this.supportsFractionalDigits(database);
        if (database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof FirebirdDatabase || database instanceof H2Database || database instanceof HsqlDatabase) {
            return new DatabaseDataType("TIMESTAMP");
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("TIMESTAMP", this.getParameters());
        }
        if (database instanceof MSSQLDatabase) {
            Object[] parameters = this.getParameters();
            if (originalDefinition.toLowerCase().startsWith("smalldatetime") || originalDefinition.toLowerCase().startsWith("[smalldatetime")) {
                return new DatabaseDataType(database.escapeDataTypeName("smalldatetime"));
            }
            if (originalDefinition.equalsIgnoreCase("datetime2") || originalDefinition.equals("[datetime2]") || originalDefinition.matches("(?i)datetime2\\s*\\(.+") || originalDefinition.matches("\\[datetime2\\]\\s*\\(.+")) {
                try {
                    if (database.getDatabaseMajorVersion() <= 9) {
                        return new DatabaseDataType(database.escapeDataTypeName("datetime"));
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
                if (parameters.length == 0) {
                    parameters = new Object[]{7};
                } else if (parameters.length > 1) {
                    parameters = new Object[]{parameters[1]};
                }
                return new DatabaseDataType(database.escapeDataTypeName("datetime2"), parameters);
            }
            return new DatabaseDataType(database.escapeDataTypeName("datetime"));
        }
        if (database instanceof InformixDatabase) {
            if ((this.getAdditionalInformation() == null || this.getAdditionalInformation().length() == 0) && this.getParameters() != null && this.getParameters().length > 0) {
                String parameter = String.valueOf(this.getParameters()[0]);
                if ("4365".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO FRACTION(3)");
                }
                if ("3594".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO SECOND");
                }
                if ("3080".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO MINUTE");
                }
                if ("2052".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO DAY");
                }
            }
            if (this.getAdditionalInformation() != null && this.getAdditionalInformation().length() > 0) {
                return new DatabaseDataType(originalDefinition);
            }
            return new DatabaseDataType("DATETIME YEAR TO FRACTION", 5);
        }
        if (database instanceof PostgresDatabase) {
            String rawDefinition = originalDefinition.toLowerCase();
            Object[] params = this.getParameters();
            if (rawDefinition.contains("tz") || rawDefinition.contains("with time zone")) {
                if (params.length == 0 || !allowFractional) {
                    return new DatabaseDataType("TIMESTAMP WITH TIME ZONE");
                }
                Object param = params[0];
                if (params.length == 2) {
                    param = params[1];
                }
                return new DatabaseDataType("TIMESTAMP(" + param + ") WITH TIME ZONE");
            }
            if (params.length == 0 || !allowFractional) {
                return new DatabaseDataType("TIMESTAMP WITHOUT TIME ZONE");
            }
            Object param = params[0];
            if (params.length == 2) {
                param = params[1];
            }
            return new DatabaseDataType("TIMESTAMP(" + param + ") WITHOUT TIME ZONE");
        }
        if (database instanceof SQLiteDatabase) {
            return new DatabaseDataType("TEXT");
        }
        if (database instanceof MySQLDatabase) {
            if (this.getParameters().length == 0 || !allowFractional) {
                return new DatabaseDataType(this.getName());
            }
            Object[] params = this.getParameters();
            Integer precision = Integer.valueOf(params[0].toString());
            if (precision > 6) {
                LogFactory.getInstance().getLog().warning("MySQL does not support a timestamp precision of '" + precision + "' - resetting to" + " the maximum of '6'");
                params = new Object[]{6};
            }
            return new DatabaseDataType(this.getName(), params);
        }
        return new DatabaseDataType(this.getName());
    }

    protected boolean supportsFractionalDigits(Database database) {
        if (database.getConnection() == null) {
            LogFactory.getInstance().getLog().warning("No database connection available - specified DATETIME/TIMESTAMP precision will be tried");
            return true;
        }
        try {
            String minimumVersion = "0";
            int major = database.getDatabaseMajorVersion();
            int minor = database.getDatabaseMinorVersion();
            int patch = 0;
            if (MySQLDatabase.class.isInstance(database)) {
                patch = ((MySQLDatabase)database).getDatabasePatchVersion();
                minimumVersion = "5.6.4";
            } else if (PostgresDatabase.class.isInstance(database)) {
                minimumVersion = "7.2";
            }
            return this.isMinimumVersion(minimumVersion, major, minor, patch);
        }
        catch (DatabaseException x) {
            LogFactory.getInstance().getLog().warning("Unable to determine exact database server version - specified TIMESTAMP precision will not be set: ", x);
            return false;
        }
    }

    protected boolean isMinimumVersion(String minimumVersion, int major, int minor, int patch) {
        int minPatch;
        String[] parts = minimumVersion.split("\\.", 3);
        int minMajor = Integer.parseInt(parts[0]);
        int minMinor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        int n = minPatch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        if (minMajor > major) {
            return false;
        }
        if (minMajor == major && minMinor > minor) {
            return false;
        }
        return minMajor != major || minMinor != minor || minPatch <= patch;
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (database.isFunction(value.toString())) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + ((String)value).replaceAll("'", "''") + "'";
        }
        return database.getDateTimeLiteral((Timestamp)value);
    }

    @Override
    public Object sqlToObject(String value, Database database) {
        if (this.zeroTime(value)) {
            return value;
        }
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
        }
        try {
            DateFormat dateTimeFormat = this.getDateTimeFormat(database);
            if (database instanceof OracleDatabase && value.matches("to_date\\('\\d+\\-\\d+\\-\\d+ \\d+:\\d+:\\d+', 'YYYY\\-MM\\-DD HH24:MI:SS'\\)")) {
                dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:s");
                value = value.replaceFirst(".*?'", "").replaceFirst("',.*", "");
            }
            return new Timestamp(dateTimeFormat.parse(value).getTime());
        }
        catch (ParseException e) {
            String[] genericFormats;
            for (String format : genericFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss"}) {
                try {
                    return new Timestamp(new SimpleDateFormat(format).parse(value).getTime());
                }
                catch (ParseException parseException) {
                }
            }
            if (value.contains("/") || value.contains("-")) {
                return value;
            }
            return new DatabaseFunction(value);
        }
    }

    private boolean zeroTime(String stringVal) {
        return stringVal.replace("-", "").replace(":", "").replace(" ", "").replace("0", "").equals("");
    }

    protected DateFormat getDateTimeFormat(Database database) {
        if (database instanceof MySQLDatabase) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        if (database instanceof MSSQLDatabase) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        if (database instanceof DB2Database) {
            return new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

