/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure.properties;

import java.io.InputStream;
import org.casbin.exception.CasbinModelConfigNotFoundException;
import org.casbin.exception.CasbinPolicyConfigNotFoundException;
import org.casbin.spring.boot.autoconfigure.properties.CasbinDataSourceInitializationMode;
import org.casbin.spring.boot.autoconfigure.properties.CasbinStoreType;
import org.casbin.spring.boot.autoconfigure.properties.CasbinWatcherType;
import org.casbin.utils.FileUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="casbin")
public class CasbinProperties {
    private boolean enableCasbin = true;
    private boolean useSyncedEnforcer = false;
    private String model = "classpath:casbin/model.conf";
    private String policy = "classpath:casbin/policy.csv";
    private CasbinStoreType storeType = CasbinStoreType.JDBC;
    private CasbinWatcherType watcherType = CasbinWatcherType.REDIS;
    private CasbinDataSourceInitializationMode initializeSchema = CasbinDataSourceInitializationMode.CREATE;
    private boolean enableWatcher = false;
    private boolean autoSave = true;
    private boolean useDefaultModelIfModelNotSetting = true;

    public String getModelContext() {
        String text = FileUtils.getFileAsText(this.model);
        if (text == null) {
            throw new CasbinModelConfigNotFoundException();
        }
        return text;
    }

    public InputStream getPolicyInputStream() {
        InputStream stream = FileUtils.getFileAsInputStream(this.policy);
        if (stream == null) {
            throw new CasbinPolicyConfigNotFoundException();
        }
        return stream;
    }

    public boolean isEnableCasbin() {
        return this.enableCasbin;
    }

    public boolean isUseSyncedEnforcer() {
        return this.useSyncedEnforcer;
    }

    public String getModel() {
        return this.model;
    }

    public String getPolicy() {
        return this.policy;
    }

    public CasbinStoreType getStoreType() {
        return this.storeType;
    }

    public CasbinWatcherType getWatcherType() {
        return this.watcherType;
    }

    public CasbinDataSourceInitializationMode getInitializeSchema() {
        return this.initializeSchema;
    }

    public boolean isEnableWatcher() {
        return this.enableWatcher;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public boolean isUseDefaultModelIfModelNotSetting() {
        return this.useDefaultModelIfModelNotSetting;
    }

    public void setEnableCasbin(boolean enableCasbin) {
        this.enableCasbin = enableCasbin;
    }

    public void setUseSyncedEnforcer(boolean useSyncedEnforcer) {
        this.useSyncedEnforcer = useSyncedEnforcer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public void setStoreType(CasbinStoreType storeType) {
        this.storeType = storeType;
    }

    public void setWatcherType(CasbinWatcherType watcherType) {
        this.watcherType = watcherType;
    }

    public void setInitializeSchema(CasbinDataSourceInitializationMode initializeSchema) {
        this.initializeSchema = initializeSchema;
    }

    public void setEnableWatcher(boolean enableWatcher) {
        this.enableWatcher = enableWatcher;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public void setUseDefaultModelIfModelNotSetting(boolean useDefaultModelIfModelNotSetting) {
        this.useDefaultModelIfModelNotSetting = useDefaultModelIfModelNotSetting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CasbinProperties)) {
            return false;
        }
        CasbinProperties other = (CasbinProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableCasbin() != other.isEnableCasbin()) {
            return false;
        }
        if (this.isUseSyncedEnforcer() != other.isUseSyncedEnforcer()) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$policy = this.getPolicy();
        String other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !this$policy.equals(other$policy)) {
            return false;
        }
        CasbinStoreType this$storeType = this.getStoreType();
        CasbinStoreType other$storeType = other.getStoreType();
        if (this$storeType == null ? other$storeType != null : !((Object)((Object)this$storeType)).equals((Object)other$storeType)) {
            return false;
        }
        CasbinWatcherType this$watcherType = this.getWatcherType();
        CasbinWatcherType other$watcherType = other.getWatcherType();
        if (this$watcherType == null ? other$watcherType != null : !((Object)((Object)this$watcherType)).equals((Object)other$watcherType)) {
            return false;
        }
        CasbinDataSourceInitializationMode this$initializeSchema = this.getInitializeSchema();
        CasbinDataSourceInitializationMode other$initializeSchema = other.getInitializeSchema();
        if (this$initializeSchema == null ? other$initializeSchema != null : !((Object)((Object)this$initializeSchema)).equals((Object)other$initializeSchema)) {
            return false;
        }
        if (this.isEnableWatcher() != other.isEnableWatcher()) {
            return false;
        }
        if (this.isAutoSave() != other.isAutoSave()) {
            return false;
        }
        return this.isUseDefaultModelIfModelNotSetting() == other.isUseDefaultModelIfModelNotSetting();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CasbinProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableCasbin() ? 79 : 97);
        result = result * 59 + (this.isUseSyncedEnforcer() ? 79 : 97);
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : $policy.hashCode());
        CasbinStoreType $storeType = this.getStoreType();
        result = result * 59 + ($storeType == null ? 43 : ((Object)((Object)$storeType)).hashCode());
        CasbinWatcherType $watcherType = this.getWatcherType();
        result = result * 59 + ($watcherType == null ? 43 : ((Object)((Object)$watcherType)).hashCode());
        CasbinDataSourceInitializationMode $initializeSchema = this.getInitializeSchema();
        result = result * 59 + ($initializeSchema == null ? 43 : ((Object)((Object)$initializeSchema)).hashCode());
        result = result * 59 + (this.isEnableWatcher() ? 79 : 97);
        result = result * 59 + (this.isAutoSave() ? 79 : 97);
        result = result * 59 + (this.isUseDefaultModelIfModelNotSetting() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CasbinProperties(enableCasbin=" + this.isEnableCasbin() + ", useSyncedEnforcer=" + this.isUseSyncedEnforcer() + ", model=" + this.getModel() + ", policy=" + this.getPolicy() + ", storeType=" + (Object)((Object)this.getStoreType()) + ", watcherType=" + (Object)((Object)this.getWatcherType()) + ", initializeSchema=" + (Object)((Object)this.getInitializeSchema()) + ", enableWatcher=" + this.isEnableWatcher() + ", autoSave=" + this.isAutoSave() + ", useDefaultModelIfModelNotSetting=" + this.isUseDefaultModelIfModelNotSetting() + ")";
    }
}

